Imports edit_text.DynaPDF

Module Module1
   Private Function PDFError(ByVal Data As IntPtr, ByVal ErrCode As Integer, ByVal ErrMessage As IntPtr, ByVal ErrType As Integer) As Integer
      Console.Write("{0}" + Chr(10), System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage))
      Return 0 ' We try to continue if an error occurrs. Any other return value breaks processing.
   End Function

   Sub Main()
      try
         Dim pdf As New CPDF

         pdf.SetOnErrorProc(AddressOf PDFError)

         ' Set the license key here if you have one
         ' pdf.SetLicenseKey("")

         ' Non embedded CID fonts depend usually on the availability of external cmaps.
         ' So, external cmaps should be loaded if possible.
         pdf.SetCMapDir(System.IO.Path.GetFullPath("../../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed Or TLoadCMapFlags.lcmRecursive)

         pdf.CreateNewPDF(Nothing)

         pdf.SetImportFlags(TImportFlags.ifImportAll Or TImportFlags.ifImportAsPage)
         pdf.SetImportFlags2(TImportFlags2.if2UseProxy)
         pdf.OpenImportFile("../../../../dynapdf_help.pdf", TPwdType.ptOpen, "")
         pdf.ImportPDFFile(1, 1.0, 1.0)

         Dim i, cnt As Integer
         Dim ctx As CPDFContentParser = New CPDFContentParser(pdf, TOptimizeFlags.ofDefault, Nothing)

         Dim out As TContent = New TContent
         Dim searchText As String = "PDF"  ' This string occurs of course very often in the help file
         Dim replaceText As String = "XDF" ' Just an example. Use also a longer or shorter string to see what happens...
         Dim curr As TTextSelection
         Dim sel As TTextSelection = New TTextSelection()

         cnt = pdf.GetPageCount()
         For i = 1 To cnt
            ' The flag cpfEnableTextSelection is required. Otherwise no text can be found.
            If ctx.ParsePage(i, TContentParseFlags.cpfEnableTextSelection, out) Then
               curr = Nothing
               ' Replace all occurences of "PDF" with "XDF" (case insensitive).
               While ctx.FindText(TSearchType.stCaseInSensitive, curr, searchText, sel)
                  ' Set the replacement string to an empty string one time to see how surrounding text will be handled...
                  ' With psrSetAltFont() you can also set the preferred alternate font to output the new text if the
                  ' original font is not available on the system.
                  ctx.ReplaceSelText(TReplaceTextFlags.rtfDefault, sel, replaceText)
                  curr = sel
               End While
               ctx.WriteToPage(TOptimizeFlags.ofDefault, Nothing)
            End If
         Next
         ctx = Nothing
         ' No fatal error occurred?
         If pdf.HaveOpenDoc() Then
            ' We write the output file into the current directory.
            Dim outFile As String = System.IO.Directory.GetCurrentDirectory() + "\out.pdf"
            If Not pdf.OpenOutputFile(outFile) Then Return
            If pdf.CloseFile() Then
               Console.Write("PDF file ""{0}"" successfully created!" + Chr(10), outFile)
               Dim p As System.Diagnostics.Process = New System.Diagnostics.Process()
               p.StartInfo.FileName = outFile
               p.Start()
            End If
         End If
         pdf = Nothing
      Catch ex As Exception
         MsgBox(ex.Message, MsgBoxStyle.Critical)
      End Try
      Console.Read()
   End Sub

End Module
